// Navigation Bar
// ------------
// Description: The navigation bar data for the website.
export interface Logo {
	src: string
	alt: string
	text: string
}

export interface NavSubItem {
	name: string
	link: string
}

export interface NavItem {
	name: string
	link: string
	submenu?: NavSubItem[]
}

export interface NavAction {
	name: string
	link: string
	style: string
	size: string
}

export interface NavData {
	logo: Logo
	navItems: NavItem[]
	navActions: NavAction[]
}

export const navigationBarData: NavData = {
	logo: {
		src: '/logo-omniblazz.png',
		alt: 'Omniblazz Logo',
		text: ''
	},
	navItems: [
		{ name: 'Beranda', link: '/' },
		{ name: 'Harga', link: '/harga/' },
		{ name: 'Fitur', link: '/fitur/' },
		{
			name: 'Informasi',
			link: '#',
			submenu: [
        { name: 'Tentang Kami', link: '/tentang-kami/' },
				{ name: 'Blog', link: '/blog/' },
				{ name: 'FAQ', link: '/faq/' }
			]
		},
		{ name: 'Kontak', link: '/kontak/' }
	],
	navActions: [
    { name: 'Login', link: 'https://app.omniblazz.com', style: 'primary', size: 'lg' }
  ]
}
