// Config
// ------------
// Description: The configuration file for the website.

export interface Logo {
	src: string
	alt: string
}

export type Mode = 'auto' | 'light' | 'dark'

export interface Config {
	siteTitle: string
	siteDescription: string
	ogImage: string
	logo: Logo
	canonical: boolean
	noindex: boolean
	mode: Mode
	scrollAnimations: boolean
}

export const configData: Config = {
	siteTitle: 'Omniblazz. Satu inbox untuk semua percakapan',
	siteDescription: 'Platform SaaS Omnichannel + Whatsapp Blast berbasis AI yang menyatukan chat & marketplace dalam satu inbox untuk mempercepat CS dan penjualan.',
  ogImage: '/og-omniblazz.png',
	logo: {
		src: '/favicon.png',
		alt: 'Omniblazz Logo'
	},
	canonical: true,
	noindex: false,
	mode: 'light',
	scrollAnimations: true
}
